<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\VinculoModel;

class VinculoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $vinculos = [
            ['designacao' => 'Autor Principal'],
            ['designacao' => 'Co-autor'],
            ['designacao' => 'Tradutor'],
            ['designacao' => 'Editor'],
            ['designacao' => 'Revisor'],
            ['designacao' => 'Ilustrador'],
            ['designacao' => 'Fotógrafo'],
            ['designacao' => 'Compositor'],
            ['designacao' => 'Arranjador'],
            ['designacao' => 'Produtor']
        ];

        foreach ($vinculos as $vinculo) {
            VinculoModel::firstOrCreate(
                ['designacao' => $vinculo['designacao']],
                $vinculo
            );
        }
    }
}
