<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\ProvinciaModel;

class ProvinciaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
  public function run(): void
    {
      $provincias = [
            ['nome' => 'Luanda', 'descricao' => 'Capital de Angola, principal centro político e econômico.'],
            ['nome' => 'Icolo e Bengo', 'descricao' => 'Província próxima a Luanda, com áreas agrícolas.'],
            ['nome' => 'Benguela', 'descricao' => 'Província costeira conhecida pelo porto do Lobito.'],
            ['nome' => 'Huambo', 'descricao' => 'Localizada no planalto central, importante centro agrícola.'],
            ['nome' => 'Bié', 'descricao' => 'Província central com forte produção agrícola.'],
            ['nome' => 'Namibe', 'descricao' => 'Província desértica com costa marítima extensa.'],
            ['nome' => 'Huíla', 'descricao' => 'Província do sul, conhecida pela cidade de Lubango.'],
            ['nome' => 'Malanje', 'descricao' => 'Conhecida pelas Quedas de Kalandula.'],
            ['nome' => 'Cuanza Norte', 'descricao' => 'Região agrícola no norte do país.'],
            ['nome' => 'Cuanza Sul', 'descricao' => 'Província costeira e agrícola ao sul de Luanda.'],
            ['nome' => 'Uíge', 'descricao' => 'Região montanhosa rica em café.'],
            ['nome' => 'Zaire', 'descricao' => 'Província no norte, fronteiriça com o Congo.'],
            ['nome' => 'Cabinda', 'descricao' => 'Enclave separado do território principal, rico em petróleo.'],
            ['nome' => 'Cunene', 'descricao' => 'Província do extremo sul, com pastagens extensas.'],
            ['nome' => 'Lunda Norte', 'descricao' => 'Área rica em diamantes.'],
            ['nome' => 'Lunda Sul', 'descricao' => 'Também produtora de diamantes.'],
            ['nome' => 'Moxico', 'descricao' => 'Maior província de Angola em extensão territorial.'],
            ['nome' => 'Moxico Leste', 'descricao' => 'Província do Leste, com grande biodiversidade.'],
            ['nome' => 'Cuando', 'descricao' => 'Província do sudeste, com grande biodiversidade.'],
            ['nome' => 'Cubango', 'descricao' => 'Província do sudeste, com grande biodiversidade.'],
            ['nome' => 'Bengo', 'descricao' => 'Província próxima a Luanda, com áreas agrícolas.'],
        ];

        foreach ($provincias as $provincia) {
            ProvinciaModel::firstOrCreate(
                ['nome' => $provincia['nome']],
                $provincia
            );
        }
    }
}
