<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MunicipioSeeder extends Seeder
{
    public function run(): void
    {
        $municipios = [
            // Luanda
            ['nome' => 'Luanda', 'provincia_id' => 2],
            ['nome' => 'Cazenga', 'provincia_id' => 2],
            ['nome' => 'Viana', 'provincia_id' => 2],
            ['nome' => 'Cacuaco', 'provincia_id' => 2],
            ['nome' => 'Kilamba Kiaxi', 'provincia_id' => 2],

            // Benguela
            ['nome' => 'Benguela', 'provincia_id' => 2],
            ['nome' => 'Lobito', 'provincia_id' => 2],
            ['nome' => 'Baía Farta', 'provincia_id' => 2],
            ['nome' => 'Catumbela', 'provincia_id' => 2],

            // Huambo
            ['nome' => 'Huambo', 'provincia_id' => 3],
            ['nome' => 'Caála', 'provincia_id' => 3],
            ['nome' => 'Longonjo', 'provincia_id' => 3],

            // Bié
            ['nome' => 'Kuito', 'provincia_id' => 4],
            ['nome' => 'Camacupa', 'provincia_id' => 4],
            ['nome' => 'Andulo', 'provincia_id' => 4],

            // Namibe
            ['nome' => 'Namibe', 'provincia_id' => 5],
            ['nome' => 'Tômbwa', 'provincia_id' => 5],
            ['nome' => 'Bibala', 'provincia_id' => 5],

            // Huíla
            ['nome' => 'Lubango', 'provincia_id' => 6],
            ['nome' => 'Chibia', 'provincia_id' => 6],
            ['nome' => 'Caconda', 'provincia_id' => 6],
        ];

        DB::table('municipios')->upsert(
            $municipios,
            ['nome', 'provincia_id'],  // Evita duplicação
            ['provincia_id']           // Atualiza se mudar a província (raro, mas seguro)
        );
    }
}
