<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\GeneroModel;

class GeneroSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $generos = [
            ['designacao' => 'Literatura'],
            ['designacao' => 'Música'],
            ['designacao' => 'Artes Visuais'],
            ['designacao' => 'Cinema'],
            ['designacao' => 'Teatro'],
            ['designacao' => 'Dança'],
            ['designacao' => 'Fotografia'],
            ['designacao' => 'Arquitetura'],
            ['designacao' => 'Design'],
            ['designacao' => 'Outros']
        ];

        foreach ($generos as $genero) {
            GeneroModel::firstOrCreate(
                ['designacao' => $genero['designacao']],
                $genero
            );
        }
    }
}
