<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\DocumentoModel;

class DocumentoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $documentos = [
            [
                'nome' => 'Manuscrito Original - Memórias de um Sonho',
                'tipo_documento_id' => 2, // Manuscrito
                'caminho_arquivo' => 'documentos/manuscrito_memorias_sonho.pdf',
                'tamanho' => 2048576, // 2MB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Contrato de Publicação - Cantos da Terra',
                'tipo_documento_id' => 1, // Contrato de Publicação
                'caminho_arquivo' => 'documentos/contrato_cantos_terra.pdf',
                'tamanho' => 1536000, // 1.5MB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Certificado de Registro - Retratos Urbanos',
                'tipo_documento_id' => 3, // Certificado de Registro
                'caminho_arquivo' => 'documentos/certificado_retratos_urbanos.pdf',
                'tamanho' => 1024000, // 1MB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Documento de Identidade - O Tempo das Palmeiras',
                'tipo_documento_id' => 4, // Documento de Identidade
                'caminho_arquivo' => 'documentos/doc_identidade_tempo_palmeiras.pdf',
                'tamanho' => 512000, // 512KB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Comprovante de Pagamento - Sinfonia do Deserto',
                'tipo_documento_id' => 5, // Comprovante de Pagamento
                'caminho_arquivo' => 'documentos/comprovante_sinfonia_deserto.pdf',
                'tamanho' => 768000, // 768KB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Autorização de Uso - Cores de Angola',
                'tipo_documento_id' => 6, // Autorização de Uso
                'caminho_arquivo' => 'documentos/autorizacao_cores_angola.pdf',
                'tamanho' => 1280000, // 1.25MB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Termo de Responsabilidade - Histórias do Mar',
                'tipo_documento_id' => 7, // Termo de Responsabilidade
                'caminho_arquivo' => 'documentos/termo_historias_mar.pdf',
                'tamanho' => 896000, // 896KB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Outros Documentos - Dança dos Ventos',
                'tipo_documento_id' => 8, // Outros
                'caminho_arquivo' => 'documentos/outros_danca_ventos.pdf',
                'tamanho' => 640000, // 640KB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Manuscrito Original - Luzes da Cidade',
                'tipo_documento_id' => 2, // Manuscrito
                'caminho_arquivo' => 'documentos/manuscrito_luzes_cidade.pdf',
                'tamanho' => 3072000, // 3MB
                'extensao' => 'pdf'
            ],
            [
                'nome' => 'Certificado de Registro - Cantos de Liberdade',
                'tipo_documento_id' => 3, // Certificado de Registro
                'caminho_arquivo' => 'documentos/certificado_cantos_liberdade.pdf',
                'tamanho' => 1152000, // 1.125MB
                'extensao' => 'pdf'
            ]
        ];

        foreach ($documentos as $documento) {
            DocumentoModel::firstOrCreate(
                ['nome' => $documento['nome']],
                $documento
            );
        }
    }
}
