<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\UserModel;

class DatabaseSeeder extends Seeder
{

    public function run(): void
    {
        $this->call([
            GeneroSeeder::class,
            VinculoSeeder::class,
            ClassificacaoSeeder::class,
            ProvinciaSeeder::class,
            MunicipioSeeder::class,
            TipoDocumentoSeeder::class,
            NacionalidadeSeeder::class,
            AutorRepresentanteLegalSeeder::class,
            AutorSeeder::class,
            DocumentoSeeder::class,
            ObraSeeder::class,
        ]);

        UserModel::firstOrCreate(
            ['email' => 'admin@admin.com'],
            [
                'name' => 'Admin',
                'email' => 'admin@admin.com',
                'password' => bcrypt('admin'),
                'email_verified_at' => now(),
            ]
        );
    }
}
