<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Infrastructure\Persistence\Eloquent\Models\AutorModel;

class AutorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $autores = [
            [
                'nome' => 'João Manuel Santos',
                'numero_identificacao' => '123456789LA123',
                'email' => 'joao.santos@email.com',
                'provincia_id' => 1, // Luanda
                'representante_legal_id' => 1,
                'telefone' => '923456789',
                'data_nascimento' => '1985-03-15',
                'pseudonimo' => 'João das Letras',
                'naturalidade' => 'Luanda',
                'nome_pai' => 'Manuel Santos',
                'nome_mae' => 'Maria Santos',
                'ocupacao' => 'Escritor',
                'endereco' => 'Rua da Independência, 123',
                'bairro' => 'Maianga',
                'municipio' => 'Luanda',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '923456789',
                'site' => 'www.joaodasletras.ao'
            ],
            [
                'nome' => 'Ana Beatriz Costa',
                'numero_identificacao' => '987654321LA456',
                'email' => 'ana.costa@email.com',
                'provincia_id' => 2, // Benguela
                'representante_legal_id' => 1,
                'telefone' => '934567890',
                'data_nascimento' => '1990-07-22',
                'pseudonimo' => 'Ana das Artes',
                'naturalidade' => 'Benguela',
                'nome_pai' => 'Carlos Costa',
                'nome_mae' => 'Beatriz Costa',
                'ocupacao' => 'Pintora',
                'endereco' => 'Avenida Marginal, 456',
                'bairro' => 'Centro',
                'municipio' => 'Benguela',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '934567890',
                'site' => 'www.anadasartes.ao'
            ],
            [
                'nome' => 'Pedro Miguel Fernandes',
                'numero_identificacao' => '456789123LA789',
                'email' => 'pedro.fernandes@email.com',
                'provincia_id' => 3, // Huambo
                'representante_legal_id' => 1,
                'telefone' => '945678901',
                'data_nascimento' => '1988-11-08',
                'pseudonimo' => 'Pedro das Músicas',
                'naturalidade' => 'Huambo',
                'nome_pai' => 'Miguel Fernandes',
                'nome_mae' => 'Isabel Fernandes',
                'ocupacao' => 'Músico',
                'endereco' => 'Rua da República, 789',
                'bairro' => 'São João',
                'municipio' => 'Huambo',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '945678901',
                'site' => 'www.pedrodasmusicas.ao'
            ],
            [
                'nome' => 'Maria José Silva',
                'numero_identificacao' => '789123456LA012',
                'email' => 'maria.silva@email.com',
                'provincia_id' => 4, // Bié
                'representante_legal_id' => 1,
                'telefone' => '956789012',
                'data_nascimento' => '1992-05-14',
                'pseudonimo' => 'Maria das Histórias',
                'naturalidade' => 'Kuito',
                'nome_pai' => 'José Silva',
                'nome_mae' => 'Rosa Silva',
                'ocupacao' => 'Professora',
                'endereco' => 'Rua da Liberdade, 012',
                'bairro' => 'Centro',
                'municipio' => 'Kuito',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '956789012',
                'site' => null
            ],
            [
                'nome' => 'Carlos Alberto Mendes',
                'numero_identificacao' => '321654987LA345',
                'email' => 'carlos.mendes@email.com',
                'provincia_id' => 5, // Namibe
                'representante_legal_id' => 1,
                'telefone' => '967890123',
                'data_nascimento' => '1987-09-30',
                'pseudonimo' => 'Carlos das Imagens',
                'naturalidade' => 'Namibe',
                'nome_pai' => 'Alberto Mendes',
                'nome_mae' => 'Carmen Mendes',
                'ocupacao' => 'Fotógrafo',
                'endereco' => 'Avenida da Praia, 345',
                'bairro' => 'Praia Amélia',
                'municipio' => 'Namibe',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '967890123',
                'site' => 'www.carlosdasimagens.ao'
            ],
            [
                'nome' => 'Isabel Cristina Rodrigues',
                'numero_identificacao' => '654321987LA678',
                'email' => 'isabel.rodrigues@email.com',
                'provincia_id' => 6, // Huíla
                'representante_legal_id' => 1,
                'telefone' => '978901234',
                'data_nascimento' => '1991-12-03',
                'pseudonimo' => 'Isabel das Danças',
                'naturalidade' => 'Lubango',
                'nome_pai' => 'Cristiano Rodrigues',
                'nome_mae' => 'Cristina Rodrigues',
                'ocupacao' => 'Bailarina',
                'endereco' => 'Rua da Cultura, 678',
                'bairro' => 'São Paulo',
                'municipio' => 'Lubango',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '978901234',
                'site' => 'www.isabeldasdancas.ao'
            ],
            [
                'nome' => 'António Manuel Pereira',
                'numero_identificacao' => '147258369LA901',
                'email' => 'antonio.pereira@email.com',
                'provincia_id' => 7, // Malanje
                'representante_legal_id' => 1,
                'telefone' => '989012345',
                'data_nascimento' => '1986-04-18',
                'pseudonimo' => 'António das Palmeiras',
                'naturalidade' => 'Malanje',
                'nome_pai' => 'Manuel Pereira',
                'nome_mae' => 'Ana Pereira',
                'ocupacao' => 'Ator',
                'endereco' => 'Rua das Palmeiras, 901',
                'bairro' => 'Centro',
                'municipio' => 'Malanje',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '989012345',
                'site' => null
            ],
            [
                'nome' => 'Sofia Alexandra Martins',
                'numero_identificacao' => '258369147LA234',
                'email' => 'sofia.martins@email.com',
                'provincia_id' => 8, // Cuanza Norte
                'representante_legal_id' => 1,
                'telefone' => '990123456',
                'data_nascimento' => '1993-08-25',
                'pseudonimo' => 'Sofia das Cores',
                'naturalidade' => 'Ndalatando',
                'nome_pai' => 'Alexandre Martins',
                'nome_mae' => 'Alexandra Martins',
                'ocupacao' => 'Designer',
                'endereco' => 'Avenida da Independência, 234',
                'bairro' => 'São José',
                'municipio' => 'Ndalatando',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '990123456',
                'site' => 'www.sofiadascores.ao'
            ],
            [
                'nome' => 'Rui Fernando Oliveira',
                'numero_identificacao' => '369147258LA567',
                'email' => 'rui.oliveira@email.com',
                'provincia_id' => 9, // Cuanza Sul
                'representante_legal_id' => 1,
                'telefone' => '901234567',
                'data_nascimento' => '1989-01-12',
                'pseudonimo' => 'Rui das Palavras',
                'naturalidade' => 'Sumbe',
                'nome_pai' => 'Fernando Oliveira',
                'nome_mae' => 'Fernanda Oliveira',
                'ocupacao' => 'Poeta',
                'endereco' => 'Rua da Poesia, 567',
                'bairro' => 'Centro',
                'municipio' => 'Sumbe',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '901234567',
                'site' => 'www.ruidaspalavras.ao'
            ],
            [
                'nome' => 'Teresa Maria Sousa',
                'numero_identificacao' => '741852963LA890',
                'email' => 'teresa.sousa@email.com',
                'provincia_id' => 10, // Uíge
                'representante_legal_id' => 1,
                'telefone' => '912345678',
                'data_nascimento' => '1994-06-07',
                'pseudonimo' => 'Teresa das Artes',
                'naturalidade' => 'Uíge',
                'nome_pai' => 'Maria Sousa',
                'nome_mae' => 'Maria Teresa Sousa',
                'ocupacao' => 'Artista Plástica',
                'endereco' => 'Rua das Artes, 890',
                'bairro' => 'São Miguel',
                'municipio' => 'Uíge',
                'nacionalidade_id' => 4, // Angolana
                'celular' => '912345678',
                'site' => 'www.teresadasartes.ao'
            ]
        ];

        foreach ($autores as $autor) {
            AutorModel::firstOrCreate(
                ['numero_identificacao' => $autor['numero_identificacao']],
                $autor
            );
        }
    }
}
