<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('obras', function (Blueprint $table) {
            // Adicionar o novo campo provincia_id como nullable primeiro
            $table->foreignId('provincia_id')
                ->nullable()
                ->after('data_registo')
                ->constrained('provincias')
                ->onDelete('cascade')
                ->comment('ID da província onde a obra foi registada');
        });

        // Atualizar registros existentes com provincia_id baseado no nome da província
        // Assumindo que existe uma província com ID 1 (Luanda) como padrão
        DB::table('obras')->update(['provincia_id' => 1]);

        // Tornar a coluna NOT NULL após atualizar os valores
        Schema::table('obras', function (Blueprint $table) {
            $table->foreignId('provincia_id')->nullable(false)->change();
        });

        // Remover o campo provincia (string) após a migração dos dados
        Schema::table('obras', function (Blueprint $table) {
            $table->dropColumn('provincia');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('obras', function (Blueprint $table) {
            // Remover o campo provincia_id
            $table->dropForeign(['provincia_id']);
            $table->dropColumn('provincia_id');

            // Restaurar o campo provincia
            $table->string('provincia')->after('data_registo');
        });
    }
};
