<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('obras', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->string('numero_certificado')->unique();
            $table->date('data_registo');
            $table->string('provincia');
            $table->foreignId('genero_id')->constrained('generos')->onDelete('cascade');
            $table->string('suporte');
            $table->foreignId('classificacao_id')->constrained('classificacoes')->onDelete('cascade');
            $table->boolean('esta_publicada')->default(false);
            $table->text('descricao')->nullable();
            $table->text('observacoes')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('obras');
    }
};
