<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('obra_publicacoes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('obra_id')->constrained('obras')->onDelete('cascade');
            $table->string('editora')->nullable();
            $table->string('num_edicao', 50)->nullable();
            $table->year('ano')->nullable();
            $table->string('produtora')->nullable();
            $table->string('local_publicacao')->nullable();
            $table->string('volume', 50)->nullable();
            $table->timestamps();

            // Garantir que cada obra só tem uma publicação
            $table->unique('obra_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('obra_publicacoes');
    }
};
