<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('obra_documentos', function (Blueprint $table) {
            $table->dropColumn(['nome_documento', 'descricao', 'obrigatorio']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('obra_documentos', function (Blueprint $table) {
            $table->string('nome_documento')->nullable();
            $table->text('descricao')->nullable();
            $table->boolean('obrigatorio')->default(false);
        });
    }
};
