<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('obra_documentos', function (Blueprint $table) {
            $table->foreignId('tipo_documento_id')
                ->nullable()
                ->constrained('tipo_documentos')
                ->onDelete('cascade')
                ->after('documento_id')
                ->comment('Tipo do documento na obra');
        });

        DB::statement('
            UPDATE obra_documentos
            SET tipo_documento_id = (
                SELECT tipo_documento_id
                FROM documentos
                WHERE documentos.id = obra_documentos.documento_id
            )
        ');

        Schema::table('obra_documentos', function (Blueprint $table) {
            $table->foreignId('tipo_documento_id')->nullable(false)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('obra_documentos', function (Blueprint $table) {
            $table->dropForeign(['tipo_documento_id']);
            $table->dropColumn('tipo_documento_id');
        });
    }
};
