<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('obra_documentos', function (Blueprint $table) {
            $table->id();

            // Chaves estrangeiras
            $table->foreignId('obra_id')
                ->constrained('obras')
                ->onDelete('cascade');

            $table->foreignId('documento_id')
                ->constrained('documentos')
                ->onDelete('cascade');

            // Campos específicos da relação
            $table->string('nome_documento')->nullable(); // Nome personalizado do documento na obra
            $table->text('descricao')->nullable(); // Descrição específica do documento na obra
            $table->integer('ordem')->default(1); // Ordem do documento na obra
            $table->boolean('obrigatorio')->default(false); // Se o documento é obrigatório para a obra

            // Timestamps
            $table->timestamps();

            // Índices
            $table->index(['obra_id', 'documento_id']);
            $table->unique(['obra_id', 'documento_id']); // Evita duplicação de documentos na mesma obra
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('obra_documentos');
    }
};
