<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('autores', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('numero_identificacao', 200)->unique();
            $table->string('email');
            $table->foreignId('provincia_id')
                ->constrained('provincias')
                ->onDelete('cascade');
            $table->foreignId('representante_legal_id')
                ->constrained('autor_representante_legal')
                ->nullable()
                ->onDelete('cascade');
            $table->string('telefone')->unique();
            $table->date('data_nascimento');

            // Campos adicionados nas migrações posteriores
            $table->string('pseudonimo', 100);
            $table->string('naturalidade');
            $table->string('nome_pai', 100);
            $table->string('nome_mae', 100);
            $table->string('ocupacao', 100);
            $table->string('endereco', 200); // Renomeado de 'enderenco'
            $table->string('bairro', 200);
            $table->string('municipio', 200);
            $table->foreignId('nacionalidade_id')
                ->constrained('nacionalidades')
                ->onDelete('cascade');
            $table->string('celular', 100)->nullable();
            $table->string('site', 100)->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('autores');
    }
};
