<?php

namespace Database\Factories;
use Illuminate\Database\Eloquent\Factories\Factory;
use Infrastructure\Persistence\Eloquent\Models\ProvinciaModel;


/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class ProvinciaFactory extends Factory
{

    protected $model = ProvinciaModel::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
          return [
            'nome' => $this->faker->word(), // ou sentence() se quiser nomes maiores
            'descricao' => $this->faker->paragraph(), // gera texto aleatório
        ];
    }
}
