<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Infrastructure\Persistence\Eloquent\Models\GeneroModel;

/**
 * @extends Factory<GeneroModel>
 */
class GeneroFactory extends Factory
{
    protected $model = GeneroModel::class;

    public function definition(): array
    {
        return [
            'designacao' => $this->faker->randomElement([
                'Literatura', 'Música', 'Poesia', 'Dança', 'Teatro', 'Pintura'
            ]),
        ];
    }
}
