<?php
namespace UI\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequestRequest extends FormRequest
{
    public function authorize(): bool 
    { 
        return true; 
    }

    public function rules(): array
    {
        return [
            'certificate_number' => 'required|string|max:255',
            'registration_date' => 'required|date|before_or_equal:today',
            'province' => 'required|string|max:255',
            'author_name' => 'required|string|max:255',
            'work_title' => 'required|string|max:500',
            'genre' => 'required|string|max:100',
            'support' => 'required|string|max:100',
            'classification' => 'required|string|max:100',
            'is_published' => 'required|boolean'
        ];
    }

    public function messages(): array
    {
        return [
            'certification_number.required' => 'O número de certificação é obrigatório.',
            'registration_date.required' => 'A data de registro é obrigatória.',
            'registration_date.date' => 'A data de registro deve ser uma data válida.',
            'registration_date.before_or_equal' => 'A data de registro não pode ser maior que a data de hoje.',
            'province.required' => 'A província é obrigatória.',
            'author_name.required' => 'O nome do autor é obrigatório.',
            'work_title.required' => 'O título da obra é obrigatório.',
            'genre.required' => 'O gênero é obrigatório.',
            'suport.required' => 'O suporte é obrigatório.',
            'classification.required' => 'A classificação é obrigatória.',
            'is_published.required' => 'O status de publicação é obrigatório.',
            'is_published.boolean' => 'O status de publicação deve ser verdadeiro ou falso.'
        ];
    }
}