<?php
namespace UI\Http\Controllers;

use App\Http\Controllers\Controller;
use Application\Shared\Search\Paginate;
use Application\Shared\Search\Search;
use Application\Shared\Search\SearchWithPagination;
use Domain\Repositories\IMunicipioRepository;
use Domain\Repositories\IProvinceRepository;

class MunicipioController extends Controller
{
    public function __construct(
        private IMunicipioRepository $repo
    ) {}

    /**
     * @OA\Get(
     *   path="/api/v1/municipio/provincia/{provinciaId}",
     *   tags={"Municipio"},
     *  @OA\Parameter(name="provinciaId", in="path", required=true, @OA\Schema(type="integer")),
     *   @OA\Response(response=200, description="Get province"),
     *   @OA\Response(response=404, description="Not found")
     * )
     */
    public function drowpDown(int $provinciaId)
    { 
         $search = new Search([]);
        
        $paginate = new Paginate(['withPagination' => false]);

        $input = new SearchWithPagination($search, $paginate);

        $result = $this->repo->list($provinciaId, $input);

        return response()->json($result->toArray());
    }
}