<?php

namespace Infrastructure\Persistence\Repositories;

use Domain\Entities\Vinculo;
use Domain\Repositories\IVinculoRepositoryInterface;
use Infrastructure\Persistence\Eloquent\Models\VinculoModel;

class EloquentVinculoRepository implements IVinculoRepositoryInterface
{
    public function save(Vinculo $vinculo): Vinculo
    {
        $model = VinculoModel::updateOrCreate(
            ['id' => $vinculo->id],
            ['designacao' => $vinculo->designacao]
        );

        return new Vinculo($model->designacao, $model->id);
    }

    public function findById(int $id): ?Vinculo
    {
        $model = VinculoModel::find($id);
        return $model ? new Vinculo($model->designacao, $model->id) : null;
    }

    public function delete(int $id): bool
    {
        return (bool) VinculoModel::destroy($id);
    }

    public function all(int $perPage = 15, int $page = 1, ?string $search = null, bool $paginate = true): array
    {
        $query = VinculoModel::query();

        if ($search) {
            $query->where('designacao', 'ILIKE', "%{$search}%");
        }

        if ($paginate) {
            $paginator = $query->paginate($perPage, ['*'], 'page', $page);
        } else {
            $paginator = $query->get();
        }

        return array_map(
            fn ($m) => new Vinculo($m->designacao, $m->id),
            $paginator->items()
        );
    }
}
