<?php
namespace Infrastructure\Persistence\Repositories;

use Domain\Entities\User;
use Domain\Repositories\UserRepositoryInterface;
use Infrastructure\Persistence\Eloquent\Models\UserModel;

class EloquentUserRepository implements UserRepositoryInterface
{
    public function save(User $user): User
    {
        $data = [
            'name' => $user->name,
            'email' => $user->email,
            'password' => $user->password,
            'role' => $user->role,
        ];

        if ($user->id) {
            $model = UserModel::find($user->id);
            $model->update($data);
        } else {
            $model = UserModel::create($data);
        }

        return $this->toEntity($model);
    }

    public function findById(int $id): ?User
    {
        $m = UserModel::find($id);
        return $m ? $this->toEntity($m) : null;
    }

    public function findByEmail(string $email): ?User
    {
        $m = UserModel::where('email', $email)->first();
        return $m ? $this->toEntity($m) : null;
    }

    public function list(int $limit = 50, int $offset = 0): array
    {
        $models = UserModel::query()->skip($offset)->take($limit)->get();
        return $models->map(fn($m) => $this->toEntity($m))->all();
    }

    public function delete(int $id): void
    {
        UserModel::destroy($id);
    }

    private function toEntity(UserModel $m): User
    {
        return new User(
            id: $m->id,
            name: $m->name,
            email: $m->email,
            password: $m->password,
            role: $m->role,
            createdAt: new \DateTimeImmutable($m->created_at),
            updatedAt: $m->updated_at ? new \DateTimeImmutable($m->updated_at) : null
        );
    }
}
