<?php

namespace Infrastructure\Persistence\Repositories;

use Domain\Entities\ObraPublicacao;
use Domain\Repositories\IObraPublicacaoRepository;
use Infrastructure\Persistence\Eloquent\Models\ObraPublicacaoModel;

class EloquentObraPublicacaoRepository implements IObraPublicacaoRepository
{
    public function save(ObraPublicacao $obraPublicacao): ObraPublicacao
    {
        $obraPublicacaoModel = ObraPublicacaoModel::create([
            'obra_id' => $obraPublicacao->obra_id,
            'editora' => $obraPublicacao->editora,
            'num_edicao' => $obraPublicacao->num_edicao,
            'ano' => $obraPublicacao->ano,
            'produtora' => $obraPublicacao->produtora,
            'local_publicacao' => $obraPublicacao->local_publicacao,
            'volume' => $obraPublicacao->volume
        ]);

        return $this->toEntity($obraPublicacaoModel);
    }

    public function findByObraId(int $obra_id): ?ObraPublicacao
    {
        $obraPublicacaoModel = ObraPublicacaoModel::where('obra_id', $obra_id)->first();

        return $obraPublicacaoModel ? $this->toEntity($obraPublicacaoModel) : null;
    }

    public function update(ObraPublicacao $obraPublicacao): ObraPublicacao
    {
        $obraPublicacaoModel = ObraPublicacaoModel::findOrFail($obraPublicacao->id);

        $obraPublicacaoModel->update([
            'editora' => $obraPublicacao->editora,
            'num_edicao' => $obraPublicacao->num_edicao,
            'ano' => $obraPublicacao->ano,
            'produtora' => $obraPublicacao->produtora,
            'local_publicacao' => $obraPublicacao->local_publicacao,
            'volume' => $obraPublicacao->volume
        ]);

        return $this->toEntity($obraPublicacaoModel->fresh());
    }

    public function delete(int $id): void
    {
        ObraPublicacaoModel::destroy($id);
    }

    public function deleteByObraId(int $obra_id): void
    {
        ObraPublicacaoModel::where('obra_id', $obra_id)->delete();
    }

    private function toEntity(ObraPublicacaoModel $obraPublicacaoModel): ObraPublicacao
    {
        return new ObraPublicacao(
            $obraPublicacaoModel->obra_id,
            $obraPublicacaoModel->editora,
            $obraPublicacaoModel->num_edicao,
            $obraPublicacaoModel->ano,
            $obraPublicacaoModel->produtora,
            $obraPublicacaoModel->local_publicacao,
            $obraPublicacaoModel->volume,
            $obraPublicacaoModel->id,
            $obraPublicacaoModel->created_at ? \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $obraPublicacaoModel->created_at->format('Y-m-d H:i:s')) : null,
            $obraPublicacaoModel->updated_at ? \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $obraPublicacaoModel->updated_at->format('Y-m-d H:i:s')) : null
        );
    }
}
