<?php 
namespace Infrastructure\Persistence\Repositories;

use Application\DTOs\Shared\DataResponse;
use Application\Shared\Search\PaginationMeta;
use Application\Shared\Search\SearchWithPagination;
use Domain\Repositories\INacionalityRepository;
use Infrastructure\Persistence\Eloquent\Models\NacionalidadeModel;
use Infrastructure\Persistence\Repositories\Shared\SearchQueryBuilder as SharedSearchQueryBuilder;

class EloquentNacionalityRepository implements INacionalityRepository
{

        public function list(SearchWithPagination $input): DataResponse
    {
        $query = NacionalidadeModel::query();

        $result = SharedSearchQueryBuilder::apply($query, $input);

        if ($input->paginate->withPagination) {
          $meta = new PaginationMeta([
                'total' => $result->total(),
                'page' => $result->currentPage(),
                'perPage' => $result->perPage(),
                'sort' => $input->search->orderBy,
                'direction' => $input->search->orderByDirection,
            ]);
             return new DataResponse($result->items(), $meta);
        }

      $items = $result->get()->toArray();
        return new DataResponse($items);
    }
}