<?php
namespace Infrastructure\Persistence\Repositories;

use Application\DTOs\Shared\DataResponse;
use Application\Shared\Search\PaginationMeta;
use Application\Shared\Search\SearchWithPagination;
use Domain\Repositories\IMunicipioRepository;
use Domain\Repositories\IProvinceRepository;
use Infrastructure\Persistence\Eloquent\Models\MunicipioModel;
use Infrastructure\Persistence\Eloquent\Models\ProvinciaModel;
use Infrastructure\Persistence\Repositories\Shared\SearchQueryBuilder as SharedSearchQueryBuilder;
use Infrastructure\Shared\SearchQueryBuilder;


class EloquentMunicipioRepository implements IMunicipioRepository
{
    public function list(int $provinciaId, SearchWithPagination $input): DataResponse
    {
        $query = MunicipioModel::query()->where('provincia_id', $provinciaId);

        $result = SharedSearchQueryBuilder::apply($query, $input);

        if ($input->paginate->withPagination) {
          $meta = new PaginationMeta([
                'total' => $result->total(),
                'page' => $result->currentPage(),
                'perPage' => $result->perPage(),
                'sort' => $input->search->orderBy,
                'direction' => $input->search->orderByDirection,
            ]);
             return new DataResponse($result->items(), $meta);
        }

                $items = $result->get()->toArray();
        return new DataResponse($items);
    }
}