<?php

namespace Infrastructure\Persistence\Repositories;

use Domain\Entities\Genero;
use Domain\Repositories\IGeneroRepositoryInterface;
use Infrastructure\Persistence\Eloquent\Models\GeneroModel;

class EloquentGeneroRepository implements IGeneroRepositoryInterface
{
    public function save(Genero $genero): Genero
    {
        $model = GeneroModel::updateOrCreate(
            ['id' => $genero->id],
            ['designacao' => $genero->designacao]
        );


        return new Genero($model->designacao, $model->id);
    }

    public function findById(string $id): ?Genero
    {
        $model = GeneroModel::find($id);
        if (!$model) {
            return null;
        }
        return new Genero($model->designacao, $model->id);
    }

    public function delete(string $id): bool
    {
        return (bool) GeneroModel::destroy($id);
    }

    public function all(?string $search = null, int $perPage = 15, int $page = 1, bool $paginate = true): array
    {
        $query = GeneroModel::query();

        if ($search) {
            $query->where('designacao', 'ILIKE', "%{$search}%");
        }

        if ($paginate) {
            $paginator = $query->paginate($perPage, ['*'], 'page', $page);
            $data = array_map(fn ($m) => new Genero($m->designacao, $m->id), $paginator->items());

            return [
                'data' => $data,
                'meta' => [
                    'current_page' => $paginator->currentPage(),
                    'per_page' => $paginator->perPage(),
                    'total' => $paginator->total(),
                    'last_page' => $paginator->lastPage(),
                ],
            ];
        }

        $models = $query->get();
        return array_map(fn ($m) => new Genero($m->designacao, $m->id), $models->all());
    }
}
