<?php
namespace Infrastructure\Persistence\Repositories;


use Domain\Entities\Document;
use Domain\Repositories\IDocumentRepository;
use Infrastructure\Persistence\Eloquent\Models\DocumentoModel;
use Illuminate\Support\Facades\DB;


class EloquentDocumentRepository implements IDocumentRepository
{
    public function save(Document $document): Document {


        $documentModel = DocumentoModel::create([
            'nome'=>$document->nome,
            'caminho_arquivo'=>$document->caminho_arquivo,
            'tamanho' =>$document->tamanho,
            'extensao'=>$document->extensao,
            'tipo_documento_id' =>$document->tipo_documento_id
        ]);

        return  new Document(
             $documentModel->id,
             $documentModel->nome,
             $documentModel->caminho_arquivo,
             $documentModel->tipo_documento_id,
             $documentModel->tamanho,
             $documentModel->extensao
             );
    }
    public function deleteAuthorDocument(int $documento_id): void
    {

         $document = DocumentoModel::find($documento_id);
         $document->autores()->detach();
        $document->delete();
    }
    public function findById(int $documento_id): ?Document
    {
        $documentModel = DocumentoModel::find($documento_id);

        if (!$documentModel) {
            return null;
        }

        return  new Document(
             $documentModel->id,
             $documentModel->nome,
             $documentModel->caminho_arquivo,
             $documentModel->tipo_documento_id,
             $documentModel->tamanho,
             $documentModel->extensao
             );
    }

    public function belongsToAuthor(int $documentoId, int $authorId): bool
    {
        return DB::table('autor_documentos')
            ->where('documento_id', $documentoId)
            ->where('autor_id', $authorId)
            ->exists();
    }
}
