<?php
namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserModel extends Authenticatable implements JWTSubject
{
    use HasFactory, Notifiable;
    

    protected $table = 'users';
    protected $fillable = ['name','email','password','role'];
    protected $hidden = ['password','remember_token'];

    // JWTSubject
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims(): array
    {
        return [];
    }

    protected static function newFactory()
{
    return \Database\Factories\UserFactory::new();
}
}
