<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ObraDocumentoModel extends Model
{
    use HasFactory;

    protected $table = 'obra_documentos';

    protected $fillable = [
        'obra_id',
        'documento_id',
        'tipo_documento_id',
        'ordem'
    ];

    protected $casts = [
        'obra_id' => 'integer',
        'documento_id' => 'integer',
        'tipo_documento_id' => 'integer',
        'ordem' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Relacionamento com a obra
     */
    public function obra(): BelongsTo
    {
        return $this->belongsTo(ObraModel::class, 'obra_id');
    }

    /**
     * Relacionamento com o documento
     */
    public function documento(): BelongsTo
    {
        return $this->belongsTo(DocumentoModel::class, 'documento_id');
    }

    /**
     * Relacionamento com o tipo de documento
     */
    public function tipoDocumento(): BelongsTo
    {
        return $this->belongsTo(TipoDocumentoModel::class, 'tipo_documento_id');
    }
}
