<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GeneroModel extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'generos';
    protected $fillable = ['designacao'];

    public function classificacoes()
    {
        return $this->hasMany(ClassificacaoModel::class, 'genero_id');
    }

    protected static function newFactory()
    {
        return \Database\Factories\GeneroFactory::new();
    }
}
