<?php

namespace Infrastructure\Persistence\Eloquent\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AutorObraModel extends Model
{
    use HasFactory;

    protected $table = 'autor_obra';

    protected $fillable = [
        'autor_id',
        'obra_id',
        'vinculo_id',
        'observacoes'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function autor(): BelongsTo
    {
        return $this->belongsTo(AutorModel::class, 'autor_id');
    }

    public function obra(): BelongsTo
    {
        return $this->belongsTo(ObraModel::class, 'obra_id');
    }

    public function vinculo(): BelongsTo
    {
        return $this->belongsTo(VinculoModel::class, 'vinculo_id');
    }
}
