<?php
namespace Infrastructure\Persistence\Eloquent\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class AutorModel extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'autores';
    //
protected $fillable = [
    'nome',
    'email',
    'provincia_id',
    'numero_identificacao',
    'telefone',
    'data_nascimento',
    'representante_legal_id',
    'pseudonimo',
    'nome_pai',
    'nome_mae',
    'nacionalidade_id',
    'bairro',
    'endereco',
    'municipio_id',
    'ocupacao',
    'naturalidade',
    'celular',
    'site',
];



    public function representanteLegal()
    {
        return $this->belongsTo(AutorRepresentanteLegalModel::class, 'representante_legal_id');
    }

        public function nacionalidade()
    {
        return $this->belongsTo(NacionalidadeModel::class, 'nacionalidade_id');
    }
        public function documentos()
    {
        return $this->belongsToMany(
            DocumentoModel::class,
            'autor_documentos',   // tabela pivô
            'autor_id',           // chave estrangeira local
            'documento_id'        // chave estrangeira do documento
        )
        ->withPivot([
            'autor_id',
            'documento_id',
            'created_at',
            'updated_at'
        ])
        ->withTimestamps();
    }

      public function provincia(): BelongsTo
    {
        return $this->belongsTo(ProvinciaModel::class,  'provincia_id');
    }

    public function municipio(): BelongsTo
    {
        return $this->belongsTo(MunicipioModel::class, 'municipio_id');
    }



}
