<?php

namespace App\Infrastructure\Filesystem;
use Domain\Services\IFileDelete;
use Illuminate\Support\Facades\Storage;

class LaravelFileDelete implements IFileDelete
{
    public function delete(string $path): void
    {
        if (Storage::disk('public')->exists($path)) {
            Storage::disk('public')->delete($path);
        }
    }
}
