<?php
namespace Domain\Repositories;

use Domain\Entities\User;

interface UserRepositoryInterface
{
    public function save(User $user): User;
    public function findById(int $id): ?User;
    public function findByEmail(string $email): ?User;
    public function list(int $limit = 50, int $offset = 0): array;
    public function delete(int $id): void;
}
