<?php

namespace Domain\Repositories;

use Domain\Entities\Vinculo;

interface IVinculoRepositoryInterface
{
    public function save(Vinculo $vinculo): Vinculo;

    public function findById(int $id): ?Vinculo;

    public function delete(int $id): bool;

    /** @return Vinculo[] */
    public function all(int $perPage = 15, int $page = 1, ?string $search = null, bool $paginate = true): array;
}
