<?php

namespace Domain\Repositories;

use Domain\Entities\Obra;

interface IObraRepository
{
    public function save(Obra $obra): Obra;
    public function findById(int $id): ?Obra;
    public function findByCertificateNumber(string $numero_certificado): ?Obra;
    public function findAll(): array;
    public function update(Obra $obra): Obra;
    public function delete(int $id): void;
    public function findByAuthor(int $autor_id): array;
}
