<?php

namespace Domain\Repositories;

use Domain\Entities\Classificacao;

interface IClassificacaoRepositoryInterface
{
    public function save(Classificacao $classificacao): Classificacao;

    public function findById(string $id): ?Classificacao;

    public function delete(string $id): bool;

    /** @return Classificacao[] */
    public function all(int $perPage = 15, int $page = 1, ?string $search = null, bool $paginate = true): array;
}
