<?php

namespace Domain\Entities;

class Vinculo
{
    public ?int $id;
    public string $designacao;
    public function __construct(
        string $designacao,
        ?int $id = null
    ) {
        $this->id = $id;
        $this->designacao = $designacao;
    }

    public function update(string $designacao): void
    {
        $this->designacao = $designacao;
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'designacao' => $this->designacao
        ];
    }
}
