<?php
namespace Domain\Entities;

class User
{
    public ?int $id;
    public string $name;
    public string $email;
    public string $password;
    public string $role;
    public \DateTimeImmutable $createdAt;
    public ?\DateTimeImmutable $updatedAt;

    public function __construct(
        ?int $id,
        string $name,
        string $email,
        string $password,
        string $role = 'user',
        ?\DateTimeImmutable $createdAt = null,
        ?\DateTimeImmutable $updatedAt = null
    ) {
        $this->id = $id;
        $this->name = $name;
        $this->email = $email;
        $this->password = $password;
        $this->role = $role;
        $this->createdAt = $createdAt ?? new \DateTimeImmutable();
        $this->updatedAt = $updatedAt;
    }
}
