<?php

namespace Domain\Entities;

class ObraPublicacao
{
    public ?int $id;
    public int $obra_id;
    public ?string $editora;
    public ?string $num_edicao;
    public ?int $ano;
    public ?string $produtora;
    public ?string $local_publicacao;
    public ?string $volume;
    public \DateTimeImmutable $createdAt;
    public ?\DateTimeImmutable $updatedAt;

    public function __construct(
        int $obra_id,
        ?string $editora = null,
        ?string $num_edicao = null,
        ?int $ano = null,
        ?string $produtora = null,
        ?string $local_publicacao = null,
        ?string $volume = null,
        ?int $id = null,
        ?\DateTimeImmutable $createdAt = null,
        ?\DateTimeImmutable $updatedAt = null
    ) {
        $this->id = $id;
        $this->obra_id = $obra_id;
        $this->editora = $editora;
        $this->num_edicao = $num_edicao;
        $this->ano = $ano;
        $this->produtora = $produtora;
        $this->local_publicacao = $local_publicacao;
        $this->volume = $volume;
        $this->createdAt = $createdAt ?? new \DateTimeImmutable();
        $this->updatedAt = $updatedAt;
    }

    public function update(
        ?string $editora = null,
        ?string $num_edicao = null,
        ?int $ano = null,
        ?string $produtora = null,
        ?string $local_publicacao = null,
        ?string $volume = null
    ): void {
        $this->editora = $editora;
        $this->num_edicao = $num_edicao;
        $this->ano = $ano;
        $this->produtora = $produtora;
        $this->local_publicacao = $local_publicacao;
        $this->volume = $volume;
        $this->updatedAt = new \DateTimeImmutable();
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'obra_id' => $this->obra_id,
            'editora' => $this->editora,
            'num_edicao' => $this->num_edicao,
            'ano' => $this->ano,
            'produtora' => $this->produtora,
            'local_publicacao' => $this->local_publicacao,
            'volume' => $this->volume,
            'created_at' => $this->createdAt->format('Y-m-d H:i:s'),
            'updated_at' => $this->updatedAt?->format('Y-m-d H:i:s')
        ];
    }
}
