<?php

namespace Domain\Entities;

final class Genero
{
    public ?int $id;
    public string $designacao;

    public function __construct(string $designacao, ?string $id = null)
    {
        $this->id = $id;
        $this->designacao = $designacao;
    }

    public function update(string $designacao): void
    {
        $this->designacao = $designacao;
    }

    public function toArray(): array
    {
        return ['id' => $this->id, 'designacao' => $this->designacao];
    }
}
