<?php

namespace Domain\Entities;

final class Classificacao
{
    public ?int $id;
    public string $designacao;
    public string $genero_id;
    public ?Genero $genero = null;

    public function __construct(
        string $designacao,
        string $genero_id,
        ?string $id = null,
        ?Genero $genero = null
    ) {
        $this->designacao = $designacao;
        $this->genero_id = $genero_id;
        $this->id = $id;
        $this->genero = $genero;
    }

    public function update(string $designacao, string $genero_id): void
    {
        $this->designacao = $designacao;
        $this->genero_id = $genero_id;
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'designacao' => $this->designacao,
            'genero_id' => $this->genero_id
        ];
    }
}
