<?php

namespace Domain\Entities;

class AutorObra
{
    public ?int $id;
    public int $autor_id;
    public int $obra_id;
    public int $vinculo_id;
    public ?Autor $autor = null;
    public ?Obra $obra = null;
    public ?Vinculo $vinculo = null;
    public ?string $observacoes = null;
    public \DateTimeImmutable $createdAt;
    public ?\DateTimeImmutable $updatedAt;

    public function __construct(
        int $autor_id,
        int $obra_id,
        int $vinculo_id,
        ?string $observacoes = null,
        ?int $id = null,
        ?Autor $autor = null,
        ?Obra $obra = null,
        ?Vinculo $vinculo = null,
        ?\DateTimeImmutable $createdAt = null,
        ?\DateTimeImmutable $updatedAt = null
    ) {
        $this->id = $id;
        $this->autor_id = $autor_id;
        $this->obra_id = $obra_id;
        $this->vinculo_id = $vinculo_id;
        $this->observacoes = $observacoes;
        $this->autor = $autor;
        $this->obra = $obra;
        $this->vinculo = $vinculo;
        $this->createdAt = $createdAt ?? new \DateTimeImmutable();
        $this->updatedAt = $updatedAt;
    }

    public function update(
        int $vinculo_id,
        ?string $observacoes = null
    ): void {
        $this->vinculo_id = $vinculo_id;
        $this->observacoes = $observacoes;
        $this->updatedAt = new \DateTimeImmutable();
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'autor_id' => $this->autor_id,
            'obra_id' => $this->obra_id,
            'vinculo_id' => $this->vinculo_id,
            'observacoes' => $this->observacoes,
            'autor' => $this->autor?->toArray(),
            'obra' => $this->obra?->toArray(),
            'vinculo' => $this->vinculo?->toArray(),
            'created_at' => $this->createdAt->format('Y-m-d H:i:s'),
            'updated_at' => $this->updatedAt?->format('Y-m-d H:i:s')
        ];
    }
}
