<?php

namespace Domain\Entities;

use DomainException;

class Autor
{
    public ?int $id;
    public string $nome;
    public string $email;
    public int $provincia_id;

    public ?AutorRepresentanteLegal $autor_representante = null;
    public string $telefone;
    public  string $data_nascimento;
    public int $nacionalidade_id;
    public string $numero_identificacao;
    public string $pseudonimo;
    public string $naturalidade;
    public string $nome_pai;
    public string $nome_mae;
    public string $ocupacao;
    public string $endereco;
    public string $bairro;
    public string $municipio_id;
    public ?string $celular = null;
    public ?string $site = null;

    public function __construct(
        ?int $id,
        string $nome,
        string $email,
        int $provincia_id,
        ?AutorRepresentanteLegal $autor_representante,
        string $telefone,
        string $data_nascimento,
        int $nacionalidade_id,
        string $numero_identificacao,
        string $pseudonimo,
        string $naturalidade,
        string $nome_pai,
        string $nome_mae,
        string $ocupacao,
        string $endereco,
        string $bairro,
        string $municipio_id,
        ?string $celular = null,
        ?string $site = null,
    ) {
        $this->id = $id;
        $this->nome = $nome;
        $this->email = $email;
        $this->provincia_id = $provincia_id;

        $this->autor_representante = $autor_representante;
        $this->telefone = $telefone;
        $this->data_nascimento = $data_nascimento;
        $this->nacionalidade_id = $nacionalidade_id;
        $this->numero_identificacao = $numero_identificacao;
        $this->pseudonimo = $pseudonimo;
        $this->naturalidade = $naturalidade;
        $this->nome_pai = $nome_pai;
        $this->nome_mae = $nome_mae;
        $this->ocupacao = $ocupacao;
        $this->endereco = $endereco;
        $this->bairro = $bairro;
        $this->municipio_id = $municipio_id;
        $this->celular = $celular;
        $this->site = $site;

        // $this->validate();

    }

    public function validate(): void
    {
        if ($this->isMenorDeIdade() && $this->autor_representante === null) {
            throw new DomainException('Autores menores de idade devem possuir um representante legal.');
        }
    }
    private function isMenorDeIdade(): bool
    {
        $nascimento = new \DateTime($this->data_nascimento);
        $hoje = new \DateTime();
        $idade = $hoje->diff($nascimento)->y;

        return $idade < 18;
    }
}
