<?php

namespace Application\UseCases;

use Domain\Entities\Genero;
use Domain\Repositories\IGeneroRepositoryInterface;

class UpdateGenero
{
    public function __construct(private IGeneroRepositoryInterface $repo)
    {
    }

    public function execute(string $id, string $designacao): ?Genero
    {
        $genero = $this->repo->findById($id);

        if (!$genero) {
            return null;
        }

        $genero->update($designacao);
        return $this->repo->save($genero);
    }
}
