<?php

namespace Application\UseCases;

use Domain\Entities\Classificacao;
use Domain\Repositories\IClassificacaoRepositoryInterface;

class UpdateClassificacao
{
    public function __construct(private IClassificacaoRepositoryInterface $repo)
    {
    }

    public function execute(string $id, string $designacao, string $genero_id): Classificacao
    {
        $classificacao = new Classificacao($designacao, $genero_id, $id);
        return $this->repo->save($classificacao);
    }
}
