<?php

namespace Application\UseCases;

use Domain\Repositories\IObraRepository;
use Domain\Repositories\IDocumentRepository;
use Domain\Services\IFileStorageService;
use Infrastructure\Persistence\Eloquent\Models\ObraDocumentoModel;
use DomainException;

class RemoveDocumentoObra
{
    public function __construct(
        private IObraRepository $obraRepository,
        private IDocumentRepository $documentRepository,
        private IFileStorageService $fileStorageService
    ) {}

    public function execute(int $obraId, int $documentoId): array
    {
        $obra = $this->obraRepository->findById($obraId);
        if (!$obra) {
            throw new DomainException('Obra não encontrada');
        }

        $documento = $this->documentRepository->findById($documentoId);
        if (!$documento) {
            throw new DomainException('Documento não encontrado');
        }

        $obraDocumento = ObraDocumentoModel::where('obra_id', $obraId)
            ->where('documento_id', $documentoId)
            ->first();

        if (!$obraDocumento) {
            throw new DomainException('Documento não está associado a esta obra');
        }

        $this->fileStorageService->deleteFile($documento->caminho_arquivo);

        $obraDocumento->delete();

        \Infrastructure\Persistence\Eloquent\Models\DocumentoModel::destroy($documentoId);

        return [
            'success' => true,
            'message' => 'Documento removido completamente com sucesso',
            'obra_id' => $obraId,
            'documento_id' => $documentoId,
            'documento_nome' => $documento->nome
        ];
    }
}
