<?php

namespace Application\UseCases;

use Domain\Entities\Vinculo;
use Domain\Repositories\IVinculoRepositoryInterface;

class ListVinculos
{
    public function __construct(private IVinculoRepositoryInterface $repo)
    {
    }

    /** @return Vinculo[] */
    public function execute(int $perPage = 15, int $page = 1, ?string $search = null, bool $paginate = true): array
    {
        return $this->repo->all($perPage, $page, $search, $paginate);
    }
}
