<?php

namespace Application\UseCases;

use Domain\Entities\Genero;
use Domain\Repositories\IGeneroRepositoryInterface;

class ListGeneros
{
    public function __construct(private IGeneroRepositoryInterface $repo)
    {
    }

    /**
     * @return Genero[]
     */
    public function execute(?string $search = null, int $perPage = 15, int $page = 1, bool $paginate = true): array
    {
        return $this->repo->all($search, $perPage, $page, $paginate);
    }
}
