<?php

namespace Application\UseCases;

use Domain\Repositories\IClassificacaoRepositoryInterface;

class ListClassificacoes
{
    public function __construct(private IClassificacaoRepositoryInterface $repo)
    {
    }

    public function execute(int $perPage = 15, int $page = 1, ?string $search = null, bool $paginate = true): array
    {
        return $this->repo->all($perPage, $page, $search, $paginate);
    }
}
