<?php

namespace Application\UseCases;

use Domain\Entities\Genero;
use Domain\Repositories\IGeneroRepositoryInterface;

class GetGeneroById
{
    public function __construct(private IGeneroRepositoryInterface $repo)
    {
    }

    public function execute(string $id): ?Genero
    {
        return $this->repo->findById($id);
    }
}
