<?php
namespace Application\UseCases;

use Domain\Repositories\IAutorRepository;
use DomainException;

class DeleteAuthor
{
    public function __construct(private IAutorRepository $repo) {}

    public function execute(int $id): void
    {
         $findAuthorById  = $this->repo->findById($id);
        if (!$findAuthorById) {
                 throw new DomainException('Autor Não Encontrado.');
        }
        $this->repo->delete($id);
    }
}